<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('id');
    protected $fillable = array('name', 'country_code', 'phone', 'email', 'password', 'image', 'active', 'is_blocked', 'is_approved', 'lang', 'is_notify', 'code', 'code_expire', 'lat', 'lng', 'map_desc', 'socket_id');

    public function addresses()
    {
        return $this->hasMany('App\Models\Address');
    }

}